# 2.Create A Public APP

Shoplazza requires a public app to complete OAuth 2.0 Authentication before it can use Shoplazza Open API resources. Therefore, during the app development phase, you need to create a public app.

## Create App Name

1. Log in to your [partner account](https://partners.shoplazza.com/) and navigate to the Partner dashboard. Select the **"Apps"** option from the left-hand panel and then click on the **"Create app"** button.

2. Here you will add the App name and click Create.

> **Note**
> The APP name serves as the representative of the application entity and is the unique identifier used by the system during backend processing logic. This name is typically not displayed in the app market or the app installation list in the store.

3. Once the App is created, your Client ID & Client Secret will be generated automatically and can be accessed from the App settings page.

## App Setup

Before you can test your App on your development store, you need to add a **Redirect URL** to the App setup so that you can Run validate to unlock Testing.

1. To add the **Redirect URL**, click Setup under the App setup.

2. Here you can add the **App URL** and **Redirect URL**.

### Configuration Details:

**App URL**: Primarily used for establishing a mutually trusted interaction authorization URL. Before the merchant installs the app, a request is sent to the app through this URL for authorization and to pass basic information such as the store name, store ID, HMAC, and installation source.

For example, you would enter the following in the APP URL field:
```
https://stamped-review.apps.shoplazza.com/api/auth
```

**Redirect URL**: The application's homepage, which the merchant will access after installing the app.

For example, you would enter the following in the Redirect URL field:
```
https://stamped-review.apps.shoplazza.com/api/auth/callback
```

**Embedded Options**: Refers to the content described in "How to Integrate Public Apps with Shoplazza Stores" within the public apps section.

**Event Subscriptions**: An event can be simply understood as a type of "notification." Event subscription means you are paying attention to a certain notification. Developers' event subscriptions are all implemented through [webhook technology](https://www.shoplazza.dev/reference/webhook-copy). Webhooks are used to push messages to developers so they can promptly understand certain business statuses and make corresponding business processing. There are currently three versions: 2020-07 and 2020-01. **Usually, selecting the 2022-01 version is sufficient**.

For details on which webhooks are available for each version, the meaning of each webhook, and how to use them, see: Appendix - Complete Webhook Organization.

**Supported Countries**: Indicate the regions where the app can be seen by developers.

## Manage Listings

The App listing will be displayed in the App store where merchants can learn more about the app features and installation. It is multilingual and currently only supports English and Chinese.

1. From the Apps setting page, go to App listing → Manage listings.

2. Click Start listing to add the required information.

3. On the listing page, you can add Basic App information, Listing content, Pricing details, and Support and resources.

### Listing Components:

**App Listing Name**: The name used for displaying the app in the app marketplace, which is seen and used by merchants, and has multilingual capabilities. In contrast, **the App Name** is for developers to manage the app and serves as the unique identifier for information transmission of the app within the system.

**Listing content**: This feature serves as a comprehensive introduction to your application, presented in the app marketplace for merchants to view. **HTML code** can be incorporated within the detailed description to enhance its visual appeal. Utilize the "Preview" function to visualize how the app will appear in the marketplace.

**Pricing details**: Select a billing model.

### Pricing Configuration Guide

Choose **one** pricing model that matches your app's payment structure:

| Billing Type | Description |
|--------------|-------------|
| **Free** | No charges of any kind |
| **Free to Install** | Free installation with paid features/upgrades<br>• Free installation + variable usage charges |
| **Recurring Charge** | Subscription-based billing (weekly/monthly/yearly)<br>**Subscription Only**<br>• Fixed periodic fee<br>**Subscription + Usage**<br>• Base subscription fee + variable usage charges<br>• Transparent usage tiers (e.g. $1/100 emails) |
| **One-Time Payment** | Single payment for permanent access |

#### 1. Free Model
[No charges for the app]

#### 2. Free to Install Model
[Free installation with optional paid features or usage-based charges]

#### 3. Recurring Charge Model

- **Subscription Only**: Fixed periodic fee (weekly/monthly/yearly)
- **Subscription + Usage**: Base subscription fee plus variable usage charges with transparent usage tiers

#### 4. One-Time Charge Model
[Single payment for permanent access to the app]

---

*Updated 1 day ago*